* Clerid_eggs_th.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Two-way ANOVA for T. dubius egg mortality";
title2 "No replication";
data mortality;
	input temp rh mortrate;
	* Apply transformations here;
	y = arsin(sqrt(mortrate));
	datalines;
15  55  0.137
15  75  0.102
15 100  0.333
20  55  0.181
20  75  0.337
20 100  0.188
25  55  0.123
25  75  0.259
25 100  0.205
30  55  0.202
30  75  0.321
30 100  0.226
35  55  0.680
35  75  0.447
35 100  0.431
37.5 55 1.000
37.5 75 1.000
37.5 100 1.000
;
run;
* Print data set;
proc print data=mortality;
run;
* Plot means, standard errors, and observations;
proc gplot data=mortality;
	plot y*temp=rh / vaxis=axis1 haxis=axis1 legend=legend1;
	symbol1 i=j v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
	legend1 label=(height=2) value=(height=2);
run;
* Two-way ANOVA with all fixed effects;
proc glm data=mortality;
	class temp rh;
	model y = temp rh;
	lsmeans temp rh / adjust=tukey cl lines;
	output out=resids p=pred r=resid;
run;
goptions reset=all;
title "Diagnostic plots to check anova assumptions";
* Plot residuals vs. predicted values;
proc gplot data=resids;
	plot resid*pred=1 / vaxis=axis1 haxis=axis1;
	symbol1 v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;run;
* Normal quantile plot of residuals;
proc univariate noprint data=resids;
	qqplot resid / normal waxis=3 height=4;
run;
quit;
